# Cuadro I.1
# Estandarizacin de datos

########################################################
# Seccin modificable por el usuario
########################################################
# Lectura de la base de datos
datos<-read.csv2("Cuadro I.1.V.csv",encoding="latin1")

# Seleccin de las variables de inters
varInteres<-c("Temperatura","Conductividad","pH","Nitrato",
              "Nitrito","Amonio","Fosfato","Silicato") 

# Seleccin de las variables de identificacin

varID<-c("Laguna","Estacin")

# Nombre del archivo de salida con los resultados de la
# estandarizacin
nomSalida<-"Salida Cuadro I.1.V.csv"

########################################################
# Seccin que realiza el procedimiento
########################################################

baseVar<-datos[,varInteres]
baseID<-datos[,varID]

# Calculo de maximos y mnimos de variables                      
maximos<-apply(baseVar,2,max)
minimos<-apply(baseVar,2,min)

resultado<-rbind(maximos,minimos)

# Estandarizacin a una escala de 0 a 1 de todas las variables dada
resultado2<-cbind(baseID,t((t(baseVar)-minimos)/(maximos-minimos)))
if(length(varID)==1) colnames(resultado2)[1]<-varID

########################################################
# Seccin que muestra los resultados
########################################################

# Muestra los resultados de mnimos y mximos
resultado

# Muestra los resultados de la estandarizacin en la escala 0 a 1.
resultado2

# Graba los resultado en el archivo de salida correspondiente
write.csv2(resultado2,nomSalida,row.names=F)







